<?php
/* --------------------------------------------------------------
   LanguageFilters.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlFilters;
use Traversable;

/**
 * Class LanguageFilters
 *
 * @package Gambio\Core\Language\SqlCriteria
 */
class LanguageFilters implements SqlFilters
{
    /**
     * @var LanguageFilter[]
     */
    private $filters;
    
    
    /**
     * LanguageFilters constructor.
     *
     * @param LanguageFilter ...$filters
     */
    private function __construct(LanguageFilter ...$filters)
    {
        $this->filters = $filters;
    }
    
    
    /**
     * @param LanguageFilter ...$filters
     *
     * @return LanguageFilters
     */
    public static function create(LanguageFilter ...$filters): LanguageFilters
    {
        return new self(...$filters);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->filters);
    }
}